/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.planning.PlanningAdapter;
import cz.insophy.inplan.planning.PlanningAlgorithmController;
import cz.insophy.inplan.planning.PlanningAlgorithmInfo;
import cz.insophy.inplan.planning.PlanningCanceledEvent;
import cz.insophy.inplan.planning.PlanningFinishedEvent;
import cz.insophy.inplan.planning.PlanningListener;
import cz.insophy.inplan.planning.PlanningProgressEvent;
import cz.insophy.inplan.planning.PlanningUnit;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class PlanningAlgorithmSupport
implements PlanningAlgorithmController {
    private AtomicBoolean cancelled;
    private AtomicBoolean applyToSuperplan;
    private AtomicBoolean complete;
    private List<PlanningListener> listeners = Collections.synchronizedList(Lists.newArrayList());
    protected volatile int iterCnt;
    protected AtomicInteger iterNo;
    protected volatile double fitness;
    protected volatile int unitCnt;
    protected AtomicInteger unitNo;
    protected PlanningUnit unit;
    private volatile PlanningAlgorithmInfo planningAlgorithmInfo;

    public PlanningAlgorithmSupport() {
        this.cancelled = new AtomicBoolean(false);
        this.applyToSuperplan = new AtomicBoolean(true);
        this.complete = new AtomicBoolean(false);
        this.iterNo = new AtomicInteger();
        this.unitNo = new AtomicInteger();
        this.fitness = Double.NaN;
    }

    @Override
    public boolean isApplyToSuperplan() {
        return this.applyToSuperplan.get();
    }

    public void finishedPlanningUnits(int unitCount) {
        this.unitNo.addAndGet(unitCount);
        this.fireProgressChanged();
    }

    public void setPlanningUnitCount(int cnt) {
        this.unitCnt = cnt;
        this.unitNo.set(0);
        this.fireProgressChanged();
    }

    public void setPlanningUnit(PlanningUnit unit) {
        this.unit = unit;
    }

    public PlanningUnit getPlanningUnit() {
        return this.unit;
    }

    public void finishedIteration() {
        this.fireProgressChanged();
        this.iterNo.incrementAndGet();
    }

    public void finishedIteration(double fitness) {
        if (!Double.isNaN(fitness)) {
            this.fitness = fitness;
        }
        this.fireProgressChanged();
        this.iterNo.incrementAndGet();
    }

    public void setIterationCount(int cnt) {
        this.iterCnt = cnt;
        this.iterNo.set(0);
        this.fireProgressChanged();
    }

    public void finishedPlanning() {
        this.fireFinished();
    }

    protected void fireCancelled() {
        PlanningCanceledEvent e = new PlanningCanceledEvent(this);
        for (PlanningListener pl : this.listeners) {
            pl.onCancel(e);
        }
    }

    protected void fireProgressChanged() {
        PlanningProgressEvent e = new PlanningProgressEvent(this);
        for (PlanningListener pl : this.listeners) {
            pl.onProgress(e);
        }
    }

    protected void fireFinished() {
        PlanningFinishedEvent e = new PlanningFinishedEvent(this);
        for (PlanningListener pl : this.listeners) {
            pl.onFinish(e);
        }
    }

    @Override
    public void cancel() {
        this.cancel(false);
    }

    @Override
    public void stop() {
        this.cancel(true);
    }

    @Override
    public void cancel(boolean usePartialResult) {
        this.cancelled.set(true);
        this.applyToSuperplan.set(usePartialResult);
        this.fireCancelled();
    }

    @Override
    public void addPlanningListener(PlanningListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removePlanningListener(PlanningListener l) {
        this.listeners.remove(l);
    }

    @Override
    public PlanningAlgorithmInfo getPlanningAlgorithmInfo() {
        Preconditions.checkState(this.planningAlgorithmInfo != null, "Planning algorithm info was not set by the planning algorithm.");
        return this.planningAlgorithmInfo;
    }

    public void setPlanningAlgorithmInfo(PlanningAlgorithmInfo planningAlgorithmInfo) {
        this.planningAlgorithmInfo = planningAlgorithmInfo;
    }

    public void setComplete(boolean complete) {
        this.complete.set(complete);
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled.get();
    }

    public static PlanningListener createCancelListenerForSubalgorithm(final PlanningAlgorithmSupport subSupport) {
        Preconditions.checkNotNull(subSupport);
        return new PlanningAdapter(){

            @Override
            public void onCancel(PlanningCanceledEvent e) {
                subSupport.cancel();
            }
        };
    }
}

